<?php
use yii\widgets\ActiveForm;
use yii\helpers\Html;
use kartik\date\DatePicker;
use yii\grid\GridView;
use app\models\ServiceItems;











use yii\web\View;
use app\assets\ExternalAsset;

$this->title = 'Payment Invoice: ' . $model->serOwn->owner;
$this->params['breadcrumbs'][] = ['label' => 'Invoices', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Paid';
?>
<div class="row">
    <!-- form pembayaran-->
    <div class="col-md-5">
        <?php $form = ActiveForm::begin(); ?>
        <?php
        echo $form->field($model, 'transaction_date')->widget(DatePicker::classname(), [
            'options' => ['placeholder' => ''],
            'removeButton' => false,
            'pluginOptions' => [
                'autoclose'=>true,
                'format' => 'yyyy-mm-dd'
            ]
        ]);
        ?>
        <?= $form->field($model, 'payment_method')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'transaction_id')->textInput(['maxlength' => true]) ?>
        <?php echo $form->field($model, 'payment')->textInput(['type'=>'number','readOnly'=> true]);?>
				<div class="col-md-6">
					<?php echo $form->field($model, 'commission', ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'commission','readOnly'=> true]) ?>
				</div>
				<div class="col-md-6">
					<?= $form->field($model, 'netcash', ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'netcash','readOnly'=> true]) ?>
				</div>
				
				<div class="col-md-6">
					<?= $form->field($model, 'water', ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'water','readOnly'=> true]) ?>
				</div>
				
				<div class="col-md-6">
					<?= $form->field($model, 'electricity', ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'electricity','readOnly'=> true]) ?>
				</div>
				
				<div class="col-md-6">
					<?= $form->field($model, 'rent', ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'rent','readOnly'=> true]) ?>
				</div>

        <div class="form-group">
            <?= Html::submitButton('Paid', ['class' => 'btn btn-success']) ?>
        </div>
        <?php ActiveForm::end(); ?>
    </div>

    <!--detail invoice-->
    <div class="col-md-7">
        <div class="well well-sm">
            <table>
                <tr>
                    <td>
                        <b>Invoiced To :</b><br>
                        
                        <?= $model->serOwn->owner;?><br>
						<?= $model->phone_no;?><br>
                        KES.<?= $model->total;?><br>
                    </td>
                    <td>          </td>
                    <td valign="top">
                        <b>Invoice #<?= $model->ref_no;?></b><br>
                        Invoice Date #<?= $model->servicedate;?><br>
                        Due Date #<?= $model->transaction_date;?><br>
                    </td>
                </tr>
                <tr>
                    <td colspan="4">
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $modelsServiceItem,
                            'layout'=>'{items}',
                            'columns' => [
								
                                
								[
									'attribute' => 'ser_name',
									'value' => 'item.ser_name',
									
								],
								'ser_descr',
								'price',
								'qnty',
								
								[
                                    'attribute'=>'amount',
                                    'value'=>function($modelServiceItem){
                                        return "KES.".number_format($modelServiceItem->amount,0);
                                    }
                                ]
                                
                            ],
                        ]); ?>
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>


