<?php

use yii\helpers\Html;
use kartik\grid\GridView;
use dosamigos\datepicker\DatePicker;
use yii\widgets\Pjax;
use kartik\export\ExportMenu;
use yii\bootstrap\Modal;
use yii\helpers\Url;
use kartik\daterange\DateRangePicker;
use app\models\Service;
use app\models\Transactions;
use kartik\daterange\DateRangeBehavior;

$this->title = 'Services';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="service-index">

	<?php
		/* Modal::begin([
			'header' => '<h4>Service Sale<h4>',
			'id' => 'modal',
			'size' => 'modal-lg',
		]);

		echo "<div id='modalContent'></div>";

		Modal::end() ;
		*/
	
	?>
	<?php
			$gridColumns = [
			['class' => 'yii\grid\SerialColumn'],
			'ref_no',
			'servicedate',
			
			[
                'attribute' => 'ser_own_id',
                'value' => 'serOwn.owner',
				
            ],
			'attendant',
			[
                'attribute' => 'payment_method',
                'value' => 'payment_method',
            ],
			[
                'attribute' => 'total',
				//'footer'=>true,
                'value' => function($model, $key, $index, $obj){
					$obj->footer +=$model->total;
					return $model->total;
				}	
            ],
			
			[
                'attribute' => 'commission',
				//'footer'=>true,
                'value' => function($model, $key, $index, $obj){
					$obj->footer +=$model->commission;
					return $model->commission;
				}	
            ],
			
			[
                'attribute' => 'netcash',
				//'footer'=>true,
                'value' => function($model, $key, $index, $obj){
					$obj->footer +=$model->netcash;
					return $model->netcash;
				}	
            ],
			'status',
			
			['class' => 'yii\grid\ActionColumn'],
		];
		
		?>
		
			<div class="row" style="background-color: #EBF5FB; margin:0px; padding-top:15px;">
			<div class="col-sm-5">
			<?php echo ExportMenu::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'columns' => $gridColumns,
				'footerRowOptions'=>['style'=>'font-weight:bold; font-size:18px; background-color: #87CEFA ;'],
				'showPageSummary' => true,
				
				 'dropdownOptions' => [
					'label' => 'Export All',
					'class' => 'btn btn-default'
				] 
			]);?>
			<?= Html::a('New sale', ['create'], ['class' => 'btn btn-success']) ?>
			</div>
			<div class="col-sm-7">
			<?php  echo $this->render('_search', ['model' => $searchModel]); ?>
			</div>
			</div>
	
	
	<?php // Pjax::begin(['id' => 'pjaxid', 'timeout' => 10000, 'enablePushState' => false]); ?>
    <?= GridView::widget([
		'id' => 'pjaxid',
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
		//'showPageSummary' => true,
		'showFooter'=>TRUE,
		'footerRowOptions'=>['style'=>'font-weight:bold; font-size:18px; background-color: #87CEFA ;'],
		
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
			
			'ref_no',
			
			[
			'attribute' => 'servicedate',
			'value' => 'servicedate',
			'format' => 'raw',
			'width' => '150px',
			'filter' => DatePicker::widget([
				'model' => $searchModel,
				'attribute' => 'servicedate',
				'language' => 'en',
				'size' => 'ms',
					'clientOptions' => [
						'autoclose' => true,
						'format' => 'yyyy-mm-dd',
						'todayBtn' => true
						
				]
					
			]),
			],

            
			[
                'attribute' => 'ser_own_id',
                'value' => 'serOwn.owner',
				'filterInputOptions' => ['class' => 'form-control','placeholder' => 'Customer name']
            ],
			
			
            //'veh_make',
			
            //'veh_model',
            //'attendant',
			[
                'attribute' => 'attendant',
                'value' => 'attendant',
				'filterInputOptions' => ['class' => 'form-control','placeholder' => 'Attendant']
            ],
            //'commission',
            //'owner',
            //'phone_no',
			//'netcash',

			/* [
					
					'attribute' => 'netcash',
					'pageSummary' => true,
					'vAlign' => 'middle',
					'width' => '210px',

					
				], */
				
			 
			[
				
                'attribute' => 'total',
				'format' => 'raw',
				'contentOptions'=>['style'=>'width: auto;text-font:bold'],
				'value' => function($model, $key, $index, $obj){
					$obj->footer +=$model->total;
					return $model->total;
				}
				
                //'pageSummary' => true,
				//'footer'=>true
            ],
			[
				
                'attribute' => 'payment',
				'format' => 'raw',
				'contentOptions'=>['style'=>'width: auto;text-font:bold'],
				'value' => function($model, $key, $index, $obj){
					$obj->footer +=$model->payment;
					return $model->payment;
				}
				
                //'pageSummary' => true,
				//'footer'=>true
            ],
			
			

			/* [
                'attribute' => 'netcash',
				//'footer' => true,
				'value' => function($model, $key, $index, $obj){
					$obj->footer +=$model->netcash;
					return $model->netcash;
				}
                //'pageSummary' => true,
				
            ],	 */	
			[
                'attribute' => 'commission',
				'value' => function($model, $key, $index, $obj){
					$obj->footer +=$model->commission;
					return $model->commission;
				}
                //'pageSummary' => true,
				//'footer'=>true
            ],	
			/*
			[
                'attribute' => 'commission',
                'pageSummary' => true
            ],
			[
                'attribute' => 'netcash',
                'pageSummary' => true
            ],   */
			'status',
			[
                'class' => 'yii\grid\ActionColumn',
                'template'=>'{view} {update} {payment} {delete}',
                'buttons'=>[
                    'payment'=> function($url,$model){
                        if($model->status==\app\models\Service::STATUS_PENDING)
                            return Html::a('<span class="glyphicon glyphicon-ok"></span>',\yii\helpers\Url::toRoute(['service/payment','id'=>$model->id]),['title'=>'payment']);
                    },
					
					
                ],
				'contentOptions' => function ($model, $key, $index, $column) {
           return ['style' => 'min-width:90px'];
     }

            ],

            //['class' => 'yii\grid\ActionColumn'],
        ],
		//'showPageSummary' => true,
		'showFooter' => true
    ]); ?>
	<?php // Pjax::end(); ?>
</div>

<?php
$script = <<< JS

	$("body").on("keyup.yiiGridView", "#pjaxid .filters input", function()
	{
     //$("#pjaxid").yiiGridView("applyFilter");
	 $.pjax.reload({container:'#pjaxid'});
});
JS;
$this->registerJs($script);
?>



