<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use wbraganca\dynamicform\DynamicFormWidget;

/* @var $this yii\web\View */
/* @var $model backend\models\Sales */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="sales-form">

    <?php $form = ActiveForm::begin(['id' => 'dynamic-form']); ?>

    <?= $form->field($model, 'customer')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'invoice_no')->textInput() ?>

    <?= $form->field($model, 'poso')->textInput() ?>

    <?= $form->field($model, 'invoice_date')->textInput() ?>

    <?= $form->field($model, 'due')->textInput() ?>
	
	
	
	<div class="row">
	
	<div class="panel panel-default">
        <div class="panel-heading"><h4><i class="glyphicon glyphicon-envelope"></i> Purchase Order Items</h4></div>
        <div class="panel-body">
             <?php DynamicFormWidget::begin([
                'widgetContainer' => 'dynamicform_wrapper', // required: only alphanumeric characters plus "_" [A-Za-z0-9_]
                'widgetBody' => '.container-items', // required: css class selector
                'widgetItem' => '.item', // required: css class
                'limit' => 4, // the maximum times, an element can be cloned (default 999)
                'min' => 1, // 0 or 1 (default 1)
                'insertButton' => '.add-item', // css class
                'deleteButton' => '.remove-item', // css class
                'model' => $modelsInvoiceItems[0],
                'formId' => 'dynamic-form',
                'formFields' => [
                    'product',
                    'description',
					'quantity',
					'price',
					'amount',
                    
                ],
            ]); ?>

            <div class="container-items"><!-- widgetContainer -->
            <?php foreach ($modelsInvoiceItems as $i => $modelInvoiceItems): ?>
                <div class="item panel panel-default"><!-- widgetBody -->
                    <div class="panel-heading">
                        <h3 class="panel-title pull-left">PO Items</h3>
                        <div class="pull-right">
                            <button type="button" class="add-item btn btn-success btn-xs"><i class="glyphicon glyphicon-plus"></i></button>
                            <button type="button" class="remove-item btn btn-danger btn-xs"><i class="glyphicon glyphicon-minus"></i></button>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div class="panel-body">
                        <?php
                            // necessary for update action.
                            if (! $modelInvoiceItems->isNewRecord) {
                                echo Html::activeHiddenInput($modelInvoiceItems, "[{$i}]id");
                            }
                        ?>
                        
                        <div class="row">
                            <div class="col-sm-3">
                                <?= $form->field($modelInvoiceItems, "[{$i}]product")->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-sm-4">
                                <?= $form->field($modelInvoiceItems, "[{$i}]description")->textInput(['maxlength' => true]) ?>
                                
                            </div>
							<div class="col-sm-2">
                                <?= $form->field($modelInvoiceItems, "[{$i}]quantity")->textInput(['maxlength' => true]) ?>
                                
                            </div>
							<div class="col-sm-1">
                                <?= $form->field($modelInvoiceItems, "[{$i}]price")->textInput(['maxlength' => true]) ?>
                                
                            </div>
							<div class="col-sm-2">
                                <?= $form->field($modelInvoiceItems, "[{$i}]amount")->textInput(['maxlength' => true]) ?>
                                
                            </div>
							
                        </div><!-- .row -->
                      
                    </div>
                </div>
            <?php endforeach; ?>
            </div>
            <?php DynamicFormWidget::end(); ?>
        </div>
    </div>
	
	</div>
	
	

    <?= $form->field($model, 'notes')->textarea(['rows' => 2]) ?>

    <?= $form->field($model, 'footer')->textarea(['rows' => 2]) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
