<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use backend\models\Patient;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model backend\models\Receipt */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="receipt-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'price')->textInput() ?>

    
	<?= $form->field($model, 'patient_id')->widget(Select2::classname(),[
		'data'=>ArrayHelper::map(Patient::find()->all(),'pat_id','patient_name'),
		'language'=>'en',
		'options'=>['placeholder'=>'Select a Continent'],
		'pluginOptions'=>[
			'allowClear'=>true
		],
	]);?>
	<?= $form->field($model, 'reg_date')->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
