<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use wbraganca\dynamicform\DynamicFormWidget;
use backend\models\Products;
use kartik\date\DatePicker;
use richardfan\widget\JSRegister;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model backend\models\Po */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="po-form">

    <?php $form = ActiveForm::begin(['id' => 'dynamic-form']); ?>

    <?= $form->field($model, 'po_no')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'description')->textarea(['rows' => 6]) ?>
	
	<div class="row">
	
	<div class="panel panel-default">
        <div class="panel-heading"><h4><i class="glyphicon glyphicon-envelope"></i> Purchase Order Items</h4></div>
        <div class="panel-body">
             <?php DynamicFormWidget::begin([
                'widgetContainer' => 'dynamicform_wrapper', // required: only alphanumeric characters plus "_" [A-Za-z0-9_]
                'widgetBody' => '.container-items', // required: css class selector
                'widgetItem' => '.item', // required: css class
                'limit' => 4, // the maximum times, an element can be cloned (default 999)
                'min' => 1, // 0 or 1 (default 1)
                'insertButton' => '.add-item', // css class
                'deleteButton' => '.remove-item', // css class
                'model' => $modelsPoItem[0],
                'formId' => 'dynamic-form',
                'formFields' => [
                    'po_item_no',
                    'quantity',
                    
                ],
            ]); ?>

            <div class="container-items"><!-- widgetContainer -->
            <?php foreach ($modelsPoItem as $i => $modelPoItem): ?>
                <div class="item panel panel-default"><!-- widgetBody -->
                    <div class="panel-heading">
                        <h3 class="panel-title pull-left">PO Items</h3>
                        <div class="pull-right">
                            <button type="button" class="add-item btn btn-success btn-xs"><i class="glyphicon glyphicon-plus"></i></button>
                            <button type="button" class="remove-item btn btn-danger btn-xs"><i class="glyphicon glyphicon-minus"></i></button>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div class="panel-body">
                        <?php
                            // necessary for update action.
                            if (! $modelPoItem->isNewRecord) {
                                echo Html::activeHiddenInput($modelPoItem, "[{$i}]id");
                            }
                        ?>
                        
                        <div class="row">
						<div class="col-sm-12">
						
	
                            <div class="col-sm-12">
                                
								<div class="col-sm-12">
         <?= $form->field($modelPoItem, "[{$i}]po_item_no")->dropDownList(
                            arrayhelper::map(Products::find()->all(),'itemes_id','item_name'),
                            ['prompt'=>'select Item', 'onchange' => 'getProduct($(this))', 'onkeyup' => 'getProduct($(this))']
                            ) ?>
    </div>  
                            </div>
							<div class="col-sm-3">
                                <?= $form->field($modelPoItem, "[{$i}]item_name")->textInput(['maxlength' => true]) ?>
                                
                            </div>
							
                            <div class="col-sm-3">
                                <?= $form->field($modelPoItem, "[{$i}]quantity")->textInput(['maxlength' => true]) ?>
                                
                            </div>
							
							<div class="col-sm-3">
                                <?= $form->field($modelPoItem, "[{$i}]cost_price")->textInput(['maxlength' => true]) ?>
                                
                            </div>
							
							<div class="col-sm-3">
                                <?= $form->field($modelPoItem, "[{$i}]sale_price")->textInput(['maxlength' => true]) ?>
                                
                            </div>
							 


                        </div><!-- .row -->
                      
                    </div>
                </div>
            <?php endforeach; ?>
            </div>
            <?php DynamicFormWidget::end(); ?>
        </div>
    </div>
	
	</div>
	 
	

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>



<?php
$script = <<< JS

function getProduct(item) {
   var index  = item.attr("id").replace(/[^0-9.]/g, "");
   var itemes_id =$('#poitem-'+index+'-po_item_no').val();
    
   $.get('index.php?r=products/price',{ itemes_id : itemes_id },function(data)
   {
      var data=$.parseJSON(data);

     $('#poitem-'+index+'-sale_price').val(data.sale_price);
     $('#poitem-'+index+'-cost_price').val(data.cost_price);
   });
}

JS;
$this->registerJs($script, $this::POS_END);
?>


