<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\EmployeesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Employees list';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="employees-index">

  

    <p>
        <?= Html::a('Create Employees', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            //'id',
            'name',
            'id_no',
            'Phone',
            'physical_address',
            'next_of_kin',
            'start_date',

            ['class' => 'yii\grid\ActionColumn',
				'contentOptions' => function ($model, $key, $index, $column) 
				{
					return ['style' => 'min-width:90px'];
				}
			
			],
        ],
    ]); ?>


</div>
