<?php
namespace mdm\admin\models\form;

use mdm\admin\components\UserStatus;
use mdm\admin\models\User;
use Yii;
use yii\base\Model;
use yii\helpers\ArrayHelper;
use app\models\AuthAssignment;
use yii\web\ForbiddenHttpException;

/**
 * Signup form
 */
class Signup extends Model
{
    public $username;
	public $firstname;
	public $secondname;
    public $email;
    public $password;
    public $retypePassword;
	public $permissions;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        $class = Yii::$app->getUser()->identityClass ? : 'mdm\admin\models\User';
        return [
            ['username', 'filter', 'filter' => 'trim'],
            ['username', 'required'],
            ['username', 'unique', 'targetClass' => $class, 'message' => 'This username has already been taken.'],
            ['username', 'string', 'min' => 2, 'max' => 255],
			
			['firstname', 'filter', 'filter' => 'trim'],
            ['firstname', 'required'],
            ['firstname', 'string', 'min' => 2, 'max' => 255],
			
			['secondname', 'filter', 'filter' => 'trim'],
            ['secondname', 'required'],
            ['secondname', 'string', 'min' => 2, 'max' => 255],

            ['email', 'filter', 'filter' => 'trim'],
            ['email', 'required'],
            ['email', 'email'],
            ['email', 'unique', 'targetClass' => $class, 'message' => 'This email address has already been taken.'],

            ['password', 'required'],
            ['password', 'string', 'min' => 6],

            ['retypePassword', 'required'],
            ['retypePassword', 'compare', 'compareAttribute' => 'password'],
        ];
    }

    /**
     * Signs user up.
     *
     * @return User|null the saved model or null if saving fails
     */
    public function signup()
    {
		if(Yii::$app->user->can('register-new-user'))
		{
			if ($this->validate()) 
			{
				$class = Yii::$app->getUser()->identityClass ? : 'mdm\admin\models\User';
				$user = new $class();
				$user->username = $this->username;
				$user->firstname = $this->firstname;
				$user->secondname = $this->secondname;
				$user->email = $this->email;
				$user->status = ArrayHelper::getValue(Yii::$app->params, 'user.defaultStatus', UserStatus::ACTIVE);
				$user->setPassword($this->password);
				$user->generateAuthKey();
				$user->save();
				/* if ($user->save()) {
					return $user;
				} */
				$permissionList = $_POST['Signup']['permissions'];
				
				foreach(
				$permissionList as $value
				)
				{
					$newPermission = new AuthAssignment;
					$newPermission->user_id = $user->id;
					$newPermission->item_name = $value;
					$newPermission->save();
					/* print_r($newPermission->getErrors());
					die(); */
					
				}
				return $user;
			}

			return null;
		}
		else
			{
				throw new ForbiddenHttpException('Access level is restricted from performing signup. Contact your admin');
			}   
	}

}
