<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Transactions;
use kartik\daterange\DateRangeBehavior;

/**
 * TransactionsSearch represents the model behind the search form of `backend\models\Transactions`.
 */
class TransactionsSearch extends Transactions
{
	public $start_date;
	public $end_date;
	
	//public $createTimeRange;
    //public $createTimeStart;
    //public $createTimeEnd;
	
	const TIME_FORMAT = 'Y-m-d';  
    public $transactionFrom;
    public $transactionTo;

    /* public function rules()
    {
        return [
            [['amount'], 'integer'],
            [['transac_desc', 'transactionFrom', 'transactionTo', 'transac_date', 'rent', 'expense','water', 'wage','electricity','netcash','transaction_ref'], 'safe'],
			
        ];
    } */
	
	/* public function rules()
    {
        return [
            [['amount','expense'], 'integer'],
			[['rent', 'water', 'electricity', 'wage','netcash'], 'double'],
            [['transac_desc', 'transaction_ref','transac_date'], 'string', 'max' => 100],
        ];
    } */
	
	
	public function rules()
    {
        return [
            [['id', 'amount', 'expense'], 'integer'],
            [['transaction_ref', 'transac_desc', 'transac_date'], 'string'],
            [['water', 'electricity', 'rent', 'netcash', 'wage'], 'number'],
        ];
    }
	

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Transactions::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
		
		/* $dataProvider->sort = new Sort([
            'defaultOrder' => [
                'transac_date' => SORT_DESC,
                'id' => SORT_DESC,
            ]
        ]); */

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        /* $query->andFilterWhere([
            //'id' => $this->id,
            'amount' => $this->amount,
             'transac_date' => $this->transac_date,
			'netcash' => $this->netcash,
			'rent' => $this->rent,
			'water' => $this->water,
			'wage' => $this->wage,
			'electricity' => $this->electricity,
			'transaction_ref' => $this->transaction_ref,
			'expense' => $this->expense,
			'transac_desc' => $this->transac_desc,
        ]); */
		
		
		$query->andFilterWhere([
            //'id' => $this->id,
            'amount' => $this->amount,
            'expense' => $this->expense,
            'water' => $this->water,
            'electricity' => $this->electricity,
            'rent' => $this->rent,
            'netcash' => $this->netcash,
            'wage' => $this->wage,
            'transac_date' => $this->transac_date,
        ]);

        $query->andFilterWhere(['like', 'transaction_ref', $this->transaction_ref])
            ->andFilterWhere(['like', 'transac_desc', $this->transac_desc]);
		
        //$query->andFilterWhere(['like', 'transac_desc', $this->transac_desc]);
		
		 /* if ($this->timestampVisitStart) {
            $query->andWhere(['>=', "transac_date", $this->timeToUTC($this->timestampVisitStart)]);
        }
        if ($this->timestampVisitStart) {
            $query->andWhere(['<=', "transac_date", $this->timeToUTC($this->timestampVisitEnd)]);
        } */
		$query->andFilterWhere(['>=', 'transac_date', $this->transactionFrom])
			->andFilterWhere(['<=', 'transac_date', $this->transactionTo]);
		

        return $dataProvider;
    }
	/* private function timeToUTC($time, $format='Y-m-d')
    {
        $timezoneOffset = \Yii::$app->formatter->asDatetime('now', 'php:O');
        return date($format, strtotime($time.$timezoneOffset));
    } */
}
