<?php

namespace app\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Service;

/**
 * ServiceSearch represents the model behind the search form of `backend\models\Service`.
 */
class ServiceSearch extends Service
{
   	public $createdFrom;
    public $createdTo;
	const TIME_FORMAT = '';  
	
    public function rules()
    {
        return [
            [['id', 'commission', 'total', 'netcash'], 'integer'],
            [['ref_no','createdFrom', 'payment','createdTo', 'servicedate', 'status', 'attendant', 'ser_own_id', 'owner', 'phone_no','status'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Service::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
		$query->joinWith('serOwn');

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'servicedate' => $this->servicedate,
			'commission' => $this->commission, 
            'total' => $this->total, 
            'netcash' => $this->netcash, 
            //'ser_own_id' => $this->ser_own_id,
			'status' => $this->status,
        ]);
		
			/* if ($this->created_at_c && $this->created_at_e) {
            $query->andWhere(['between', 'date(servicedate)', $this->created_at_c, $this->created_at_e]);
    } */
	$query->andFilterWhere(['>=', 'servicedate', $this->createdFrom])
      ->andFilterWhere(['<=', 'servicedate', $this->createdTo]);

        $query->andFilterWhere(['like', 'ref_no', $this->ref_no])
            //->andFilterWhere(['like', 'reg_no', $this->reg_no])
            //->andFilterWhere(['like', 'veh_make', $this->veh_make])
            //->andFilterWhere(['like', 'veh_model', $this->veh_model])
            ->andFilterWhere(['like', 'attendant', $this->attendant])
            ->andFilterWhere(['like', 'commission', $this->commission])
            //->andFilterWhere(['like', 'owner', $this->owner])
            ->andFilterWhere(['like', 'phone_no', $this->phone_no])
			->andFilterWhere(['like', 'owner.reg_no', $this->ser_own_id]);

        return $dataProvider;
    }
}
