<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "service".
 *
 * @property int $id
 * @property string $ref_no
 * @property string $servicedate
 * @property string $ser_own_id
 * @property string $veh_make
 * @property string $veh_model
 * @property string $attendant
 * @property string $commission
 * @property string $owner
 * @property string $phone_no
 * @property int $total 
 */
class Service extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
	const STATUS_PENDING = 'pending' ; // invoice issued   
	const STATUS_PAID = 'paid' ; // invoice paid   
	const STATUS_CANCELED = 'canceled' ; // invoice canceled   
	
	
    public static function tableName()
    {
        return 'service';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
			[['payment','transaction_date','payment_method','transaction_id', 'commission', 'netcash', 'rent', 'electricity', 'water'],'required','on'=>'payment'],
            [['status',  'attendant', /* 'owner', */ 'phone_no', 'total'], 'required'],
            [['servicedate','transaction_date'], 'safe'],
			[['commission', 'netcash', 'rent', 'electricity', 'water'], 'double'],
			[['total', 'ser_own_id', 'payment','id'], 'integer'],
            [['ref_no'], 'string', 'max' => 10],
            [['attendant', 'phone_no', 'transaction_id'], 'string', 'max' => 20],
            //[['owner'], 'string', 'max' => 30],
			[['payment_method'], 'string', 'max' => 50],
			[['ser_own_id'], 'exist', 'skipOnError' => true, 'targetClass' => Owner::className(), 'targetAttribute' => ['ser_own_id' => 'owner_id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'ref_no' => 'Reference no.',
            'servicedate' => 'Service date',
            //'reg_no' => 'Registration no.',
            //'veh_make' => 'Vehicle make',
            //'veh_model' => 'Vehicle model',
            'attendant' => 'Attendant',
            'commission' => 'Commision',
            //'owner' => 'Owner name',
            'phone_no' => 'Phone/Contact',
			'total' => 'Amount due',
			'netcash' => 'Net amount',
			'ser_own_id' => 'Customers name',
			'payment' => 'Total payment',
			'payment' => 'Total payment',
			'transaction_date' => 'transaction_date',
			'payment_method' => 'payment_method',
			'transaction_id' => 'Transaction id',
			'status' => 'Payment status',
			'rent' => 'Rent',
			'electricity' => 'Electricity',
			'water' => 'Water',
			
			
        ];
    }
	
	/**
    * @return \yii\db\ActiveQuery
    */
  public function getSerOwn()
  {
      return $this->hasOne(Owner::className(), ['owner_id' => 'ser_own_id']);
  }
  public function afterSave($insert, $changedAttributes)
	{
		if($insert){
			//sebagai sample saja untuk mengenerate nomor invoice
			//format : tahun-bulan-id database
			$number = date('Y').date('m').str_pad($this->id,4,0,STR_PAD_LEFT);
			$this->updateAttributes(['ref_no'=>$number]);
		}
		parent::afterSave($insert, $changedAttributes);
	}
}
