<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "sales".
 *
 * @property int $id
 * @property string $customer
 * @property int $invoice_no
 * @property int $poso
 * @property string $invoice_date
 * @property string $due
 * @property string $notes
 * @property string $footer
 *
 * @property InvoiceItems[] $invoiceItems
 */
class Sales extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'sales';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer', 'invoice_no', 'poso', 'invoice_date', 'due', 'notes', 'footer'], 'required'],
            [['invoice_no', 'poso'], 'integer'],
            [['invoice_date', 'due'], 'safe'],
            [['notes', 'footer'], 'string'],
            [['customer'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'customer' => 'Customer',
            'invoice_no' => 'Invoice No',
            'poso' => 'P.O/S.O',
            'invoice_date' => 'Invoice Date',
            'due' => 'Payment Due',
            'notes' => 'Notes',
            'footer' => 'Footer',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvoiceItems()
    {
        return $this->hasMany(InvoiceItems::className(), ['sales_id' => 'id']);
    }
}
