<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "receipt".
 *
 * @property int $receipt_id
 * @property int $price
 * @property int $patient_id
 *
 * @property Patient $patient
 */
class Receipt extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'receipt';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['price'], 'required'],
            [['price', 'patient_id'], 'integer'],
			[['reg_date'], 'safe'],
            [['patient_id'], 'exist', 'skipOnError' => true, 'targetClass' => Patient::className(), 'targetAttribute' => ['patient_id' => 'pat_id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'receipt_id' => 'Receipt ID',
            'price' => 'Price',
			'reg_date' => 'Reg Date',
            'patient_id' => 'Patient Name',
        ];
    }
	public static function getTotal($provider, $fieldName)
{
    $total = 0;

    foreach ($provider as $item) {
        $total += $item[$fieldName];
    }

    return $total;
}

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPatient()
    {
        return $this->hasOne(Patient::className(), ['pat_id' => 'patient_id']);
    }
}
