<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "patient".
 *
 * @property int $pat_id
 * @property string $patient_name
 * @property string $reg_date
 *
 * @property Receipt[] $receipts
 */
class Patient extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'patient';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['patient_name', 'reg_date'], 'required'],
            [['reg_date'], 'safe'],
            [['patient_name'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'pat_id' => 'Pat ID',
            'patient_name' => 'Patient Name',
            'reg_date' => 'Reg Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReceipts()
    {
        return $this->hasMany(Receipt::className(), ['patient_id' => 'pat_id']);
    }
}
