<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "items".
 *
 * @property int $itemes_id
 * @property string $ser_name
 * @property string $ser_descr
 * @property int $price
 * @property int $qnty
 */
class Items extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'items';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['ser_name', 'ser_descr', 'price', 'qnty'], 'required'],
            [['ser_descr'], 'string'],
            [['price', 'qnty', 'itemoid'], 'integer'],
            [['ser_name'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'itemes_id' => 'Itemes ID',
            'ser_name' => 'Service name',
            'ser_descr' => 'Service description',
            'price' => 'Service price',
            'qnty' => 'Quantity',
			'itemoid' => 'Itemoid',
        ];
    }
	
	/** 
    * @return \yii\db\ActiveQuery 
    */ 
   public function getServiceItems() 
   { 
       return $this->hasMany(ServiceItem::className(), ['item_id' => 'itemes_id']); 
   } 
}
