<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "invoice_items".
 *
 * @property int $id
 * @property string $product
 * @property string $description
 * @property double $quantity
 * @property double $price
 * @property double $amount
 * @property int $sales_id
 *
 * @property Sales $sales
 */
class InvoiceItems extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'invoice_items';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'product', 'description', 'quantity', 'price', 'amount'], 'required'],
            [['id', 'sales_id'], 'integer'],
            [['description'], 'string'],
            [['quantity', 'price', 'amount'], 'number'],
            [['product'], 'string', 'max' => 100],
            [['id'], 'unique'],
            [['sales_id'], 'exist', 'skipOnError' => true, 'targetClass' => Sales::className(), 'targetAttribute' => ['sales_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'product' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'price' => 'Price',
            'amount' => 'Amount',
            'sales_id' => 'Sales ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSales()
    {
        return $this->hasOne(Sales::className(), ['id' => 'sales_id']);
    }
}
