<?php

namespace app\controllers;

use Yii;
use app\models\Transactions;
use app\models\Service;
use app\models\TransactionsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\web\ForbiddenHttpException;

/**
 * TransactionsController implements the CRUD actions for Transactions model.
 */
class TransactionsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Transactions models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TransactionsSearch();
		$modelserve = new Service();
		
		//if(Yii::$app->user->can('View all transactions records'))
		//{
			$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
			$query = (new \yii\db\Query())->from('transactions');
			$sum = $query->sum('amount');
			$wage = $sum * 20;
			$total = $wage - $sum;

			return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider,
				'sum'=>$sum,
				'wage'=>$wage,
				'total' => $total,
			]);
		//}
		/* else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}    */
       
    }
	//->select(['id', 'transaction_ref', 'amount'])
	public function actionTest() {
	   $query = (new \yii\db\Query())->from('transactions')
		  ->where(['between', 'transac_date', '2020-05-08', '2020-05-08']);
	   //var_dump($users);
	   $sum = $query->sum('amount');
	   
	   return $this->render('test', [
           //'searchModel' => $searchModel,
            //'dataProvider' => $dataProvider,
			'sum'=>$sum,
			
        ]);
	}


    /**
     * Displays a single Transactions model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
		if(Yii::$app->user->can('View single transaction record'))
		{
				 return $this->render('view', [
				'model' => $this->findModel($id),
			]);
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}   
       
    }
	
	/* public function actionPage()
    {
		//public $sum = 0;
        $model = new Transactions();
		$amount = '';

        //$resource_cnt = Yii::app()->db->createCommand()->select('id, sum(amount) as amt')->from('transactions');
		

        return $this->render('page', [
            'amount' => $amount,
        ]);
    } */
	public function actionReport()
    {
        $searchModel = new TransactionsSearch();
		
		if(Yii::$app->user->can('View all transactions report'))
		{
				$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
			$queryIncome = (new \yii\db\Query())->from('transactions');
			$sumIncome = $queryIncome->sum('amount');
			
			$queryExpense = (new \yii\db\Query())->from('transactions');
			$sumExpense = $queryExpense->sum('expense');
			
			$queryWater = (new \yii\db\Query())->from('transactions');
			$sumWater = $queryWater->sum('water');
			
			$queryRent = (new \yii\db\Query())->from('transactions');
			$sumRent = $queryRent->sum('Rent');
			
			$queryElectricity = (new \yii\db\Query())->from('transactions');
			$sumElectricity = $queryElectricity->sum('Electricity');
			
			$queryWage = (new \yii\db\Query())->from('transactions');
			$sumWage = $queryWage->sum('Wage');
			
			$expenseTotal = $sumExpense + $sumWater + $sumRent + $sumElectricity + $sumWage;
			
			$netCash = $sumIncome - $expenseTotal;

			return $this->render('report', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider,
				'sumIncome'=>$sumIncome,
				'sumExpense'=>$sumExpense,
				'netCash' => $netCash,
				'expenseTotal' => $expenseTotal,
			]);
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}   
		
        
    }

    /**
     * Creates a new Transactions model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionExpense()
    {
        $model = new Transactions();
		if(Yii::$app->user->can('create-expense'))
		{
			if ($model->load(Yii::$app->request->post())) {
				$model->amount = 0;
				$model->rent = 0;
				$model->water = 0;
				$model->wage = 0;
				$model->electricity = 0;
				$model->netcash = 0 - $model->expense;
				
				$model->save();
				return $this->redirect(['index']);
			}

			return $this->render('expense', [
				'model' => $model,
			]);
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from adding expense. Contact your admin');
		}   
    }
	
	/* if(Yii::$app->user->can('create-expense'))
		{
			
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}    */
	
	
	public function actionIncome()
    {
        $model = new Transactions();
		
		if(Yii::$app->user->can('Add other income'))
		{
			if ($model->load(Yii::$app->request->post())) {
			//$model->amount = 0;
			$model->rent = 0;
			$model->water = 0;
			$model->wage = 0;
			$model->electricity = 0;
			$model->netcash = 0 + $model->amount;
			//$model->amount = $model->amount;
			
			$model->expense = 0;
			
			$model->save();
            return $this->redirect(['index']);
        }

        return $this->render('income', [
            'model' => $model,
        ]);
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}   

        
    }

    /**
     * Updates an existing Transactions model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
		
		if(Yii::$app->user->can('Update transaction records'))
		{
			if ($model->load(Yii::$app->request->post())) {
			if($model->amount > 0){
			$model->netcash = 0 + $model->amount - $model->wage - $model->rent - $model->electricity - $model->water;
			}
			else{
				$model->netcash = 0 - $model->expense;
			}
			$model->save();
            return $this->redirect(['index']);
        }
		
		

        return $this->render('update', [
            'model' => $model,
        ]);
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
		
        
    }
	
	
	
	
    /**
     * Deletes an existing Transactions model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
		if(Yii::$app->user->can('create-expense'))
		{
			$this->findModel($id)->delete();

			return $this->redirect(['index']);
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
        
    }

    /**
     * Finds the Transactions model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Transactions the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Transactions::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
