<?php

namespace app\controllers;

use Yii;
use app\models\Service;
use app\models\Transactions;
use app\models\Items;
use app\models\ServiceItem;
use app\models\Model;
use app\models\ServiceSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use kartik\mpdf\Pdf;
use yii\data\ActiveDataProvider;
use yii\web\Response;
use yii\widgets\ActiveForm;
use yii\web\ForbiddenHttpException;

/**
 * ServiceController implements the CRUD actions for Service model.
 */
class ServiceController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
	
	/* if(Yii::$app->user->can('create-expense'))
		{
			
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}    */
	

    /**
     * Lists all Service models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ServiceSearch();
		$trans = new Transactions();
		/* if(Yii::$app->user->can('create-expense'))
		{
			
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		} */
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
		 $session = Yii::$app->session;
			// check if a session is already open
			if (!$session->isActive){
				$session->open();// open a session
			} 
			// save query here
			$session['repquery'] = Yii::$app->request->queryParams;


        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
	

    /**
     * Displays a single Service model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    /* public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    } */
	
	/**
 * generate pdf .
 * @param integer $id
 * @return mixed
 * @throws NotFoundHttpException if the model cannot be found
 */
	public function actionView($id)
	{
		if(Yii::$app->user->can('View single sales record'))
		{
				// get your HTML raw content without any layouts or scripts
			$model = $this->findModel($id);
			$modelsServiceItem = ServiceItem::find()->where(['service_id'=>$id])->all();
			$content = $this->renderPartial('view',['model'=>$model,'modelsServiceItem'=>$modelsServiceItem]);
			
			/* $model = $this->findModel($id);
			$items = InvoiceItem::find()->where(['id_invoice'=>$id])->all();
			$content = $this->renderPartial('view',['model'=>$model,'items'=>$items]); */


			// setup kartik\mpdf\Pdf component
			$pdf = new Pdf([
				// set to use core fonts only
				'mode' => Pdf::MODE_CORE,
				// A4 paper format
				'format' => Pdf::FORMAT_A4,
				// portrait orientation
				'orientation' => Pdf::ORIENT_PORTRAIT,
				// stream to browser inline
				'destination' => Pdf::DEST_BROWSER,
				// your html content input
				'content' => $content,
				// format content from your own css file if needed or use the
				// enhanced bootstrap css built by Krajee for mPDF formatting
				'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
				// any css to be embedded if required
				'cssInline' => '.kv-heading-1{font-size:18px}',
				// set mPDF properties on the fly
				'options' => ['title' => 'Invoice number'],
				// call mPDF methods on the fly
				'methods' => [
					'SetHeader'=>false,
					'SetFooter'=>false,
				]
			]);

			// return the pdf output as per the destination setting
			return $pdf->render();
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
		
	}

    /**
     * Creates a new Service model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Service();
		$modelsServiceItem = [new ServiceItem];
		//$modelServiceItem->item_id = Yii::app()->items->itemes_id;
		
		if(Yii::$app->user->can('Create new sales'))
		{
			
			if ($model->load(Yii::$app->request->post())) 
			{
			
			$model->servicedate = date('Y-m-d');
			//if (!$model->date) $model->date = date('Y-m-d');
            $model->status = Service::STATUS_PENDING;
			
            $modelsServiceItem = Model::createMultiple(ServiceItem::classname());
            Model::loadMultiple($modelsServiceItem, Yii::$app->request->post());
			

              // ajax validation
            if (Yii::$app->request->isAjax) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ArrayHelper::merge(
                    ActiveForm::validateMultiple($modelsServiceItem),
                    ActiveForm::validate($model)
                );
            } 

            // validate all models
            $valid = $model->validate();
            $valid = Model::validateMultiple($modelsServiceItem) && $valid;
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $model->save(false)) {
                        foreach ($modelsServiceItem as $modelServiceItem) {
                            $modelServiceItem->service_id = $model->id;
							//$modelItems->itemes_id = $modelServiceItem->ser_name;
                            if (! ($flag = $modelServiceItem->save(false))) {
                                $transaction->rollBack();
                                break;
                            }
                        }
                    }
                    if ($flag) {
                        $transaction->commit();
                        Yii::$app->session->setFlash('success', 'Invoice created successfully');
                        return $this->redirect(['index']);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
					$model->invoice_number = '';
                    Yii::$app->session->setFlash('error', 'Oops! rollback!');
                }
            }
		

        }

        return $this->render('create', [
            'model' => $model,
			'modelsServiceItem' => (empty($modelsServiceItem)) ? [new ServiceItem] : $modelsServiceItem
        ]);
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
		
        
    }

    /**
     * Updates an existing Service model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
       if(Yii::$app->user->can('Update sales records'))
		{
			$model = $this->findModel($id);
			$modelsServiceItem = ServiceItem::find()->where(['id'=>$id])->all(); //$model->modelsServiceItem;

			if ($model->load(Yii::$app->request->post())) {

				$oldIDs = ArrayHelper::map($modelsServiceItem, 'id', 'id');
				$modelsServiceItem = Model::createMultiple(ServiceItem::classname(),$modelsServiceItem);
				Model::loadMultiple($modelsServiceItem, Yii::$app->request->post());
				//list item yang akan didelete
				$deletedIDs = array_diff($oldIDs, array_filter(ArrayHelper::map($modelsServiceItem, 'id', 'id')));


				// ajax validation
				 if (Yii::$app->request->isAjax) {
					Yii::$app->response->format = Response::FORMAT_JSON;
					return ArrayHelper::merge(
						ActiveForm::validateMultiple($modelsServiceItem),
						ActiveForm::validate($model)
					);
				} 

				// validate all models
				$valid = $model->validate();
				$valid = Model::validateMultiple($modelsServiceItem) && $valid;

				if ($valid) {
					$transaction = \Yii::$app->db->beginTransaction();
					try {
						if ($flag = $model->save(false)) {
							if (! empty($deletedIDs)) {
								ServiceItem::deleteAll(['id' => $deletedIDs]);
							}
							foreach ($modelsServiceItem as $modelServiceItem) {
								$modelServiceItem->service_id = $model->id;
								//$modelServiceItem->item_id = $model->id;
								if (! ($flag = $modelServiceItem->save(false))) {
									$transaction->rollBack();
									break;
								}
							}

							
						}
						if ($flag) {
							$transaction->commit();
							Yii::$app->session->setFlash('success', 'Invoice updated successfully');
							return $this->redirect(['index']);
						}
					} catch (\Exception $e) {
						$transaction->rollBack();
						Yii::$app->session->setFlash('error', 'Oops! rollback!');
					}
				}else{
					Yii::$app->session->setFlash('error', 'Oops! System error!');
				}
			}

			return $this->render('update', [
				'model' => $model,
				'modelsServiceItem' => (empty($modelsServiceItem)) ? [new ServiceItem()] : $modelsServiceItem
			]);
		
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
		
			
		
    }

    /**
     * Deletes an existing Service model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
		if(Yii::$app->user->can('Delete sales records'))
		{
			
			$this->findModel($id)->delete();

			return $this->redirect(['index']);
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
        
    }
	
	// for the payment process
    public function actionPayment($id)
	{
        // check whether the invoice status is still created
		$tran = new Transactions();
		if(Yii::$app->user->can('Accept payment'))
		{
			$model = $this->findModel($id);
			if($model->status !== Service::STATUS_PENDING)
				throw new NotFoundHttpException('The requested page does not exist.');

			// add a payment scenario to activate the rule in the model
			$model->scenario = 'payment';
			$model->transaction_date = date('Y-m-d');
			$model->payment = $model->total;
			$model->commission = 25 / 100 * $model->payment;
			$model->water = 7.5 / 100 * $model->payment;
			$model->electricity = 6.5 / 100 * $model->payment;
			$model->rent = 18 / 100 * $model->payment;
			$model->netcash = $model->payment - $model->commission - $model->water - $model->electricity - $model->rent;
			$tran->amount = $model->total;

			// query invoice item data to display
			$modelsServiceItem = new ActiveDataProvider([
				'query' => ServiceItem::find()->where(['service_id'=>$id]),
			]);

			if($model->load(Yii::$app->request->post())){
				// change status to 'paid'
				$model->status = Service::STATUS_PAID;
				$model->total = 0;
				if($model->save(false)){
					
					$tran->transac_desc = $model->owner;
					$tran->transac_date = $model->servicedate;
					$tran->transaction_ref = $model->ref_no;
					//$tran->expense = $model->commission;
					$tran->wage = $model->commission;
					$tran->water = $model->water;
					$tran->rent = $model->rent;
					$tran->netcash = $model->netcash;
					$tran->electricity = $model->electricity;
					$tran->save();
					
					Yii::$app->session->setFlash('success' , 'Payment data saved successfully');
					return $this->redirect(['service/index']);
					
					
				}
			}

			return $this->render('payment', [
				'model' => $model,
				'modelsServiceItem' => $modelsServiceItem
			]);
			
			
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
        
    }

    /**
     * Finds the Service model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Service the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Service::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
